/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.fop.layoutmgr.LayoutManager;

public class Position {
    private LayoutManager layoutManager;
    private int index = -1;

    public Position(LayoutManager lm) {
        this.layoutManager = lm;
    }

    public Position(LayoutManager lm, int index2) {
        this(lm);
        this.setIndex(index2);
    }

    public LayoutManager getLM() {
        return this.layoutManager;
    }

    public LayoutManager getLM(int depth) {
        Position subPos = this.getPosition(depth);
        if (subPos == null) {
            return null;
        }
        return subPos.getLM();
    }

    public Position getPosition() {
        return null;
    }

    public Position getPosition(int depth) {
        Position subPos = this;
        for (int i = 0; i < depth && subPos != null; ++i, subPos = subPos.getPosition()) {
        }
        return subPos;
    }

    public boolean generatesAreas() {
        return false;
    }

    public void setIndex(int value2) {
        this.index = value2;
    }

    public int getIndex() {
        return this.index;
    }

    protected String getShortLMName() {
        if (this.getLM() != null) {
            String lm = this.getLM().toString();
            int idx = lm.lastIndexOf(46);
            if (idx >= 0 && lm.indexOf(64) > 0) {
                return lm.substring(idx + 1);
            }
            return lm;
        }
        return "null";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Position:").append(this.getIndex()).append("(");
        sb.append(this.getShortLMName());
        sb.append(")");
        return sb.toString();
    }
}

