/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.ps.ImageEncoderCCITTFax;
import org.apache.fop.render.ps.PSImageFormResource;
import org.apache.fop.render.ps.PSImageHandler;
import org.apache.fop.render.ps.PSRenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.impl.ImageRawCCITTFax;
import org.apache.xmlgraphics.ps.ImageFormGenerator;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSImageUtils;

public class PSImageHandlerRawCCITTFax
implements PSImageHandler {
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.RAW_CCITTFAX};

    public void handleImage(RenderingContext context, Image image2, Rectangle pos) throws IOException {
        PSRenderingContext psContext = (PSRenderingContext)context;
        PSGenerator gen = psContext.getGenerator();
        ImageRawCCITTFax ccitt = (ImageRawCCITTFax)image2;
        float x = (float)pos.getX() / 1000.0f;
        float y = (float)pos.getY() / 1000.0f;
        float w = (float)pos.getWidth() / 1000.0f;
        float h = (float)pos.getHeight() / 1000.0f;
        Rectangle2D.Float targetRect = new Rectangle2D.Float(x, y, w, h);
        ImageInfo info = image2.getInfo();
        ImageEncoderCCITTFax encoder2 = new ImageEncoderCCITTFax(ccitt);
        PSImageUtils.writeImage(encoder2, info.getSize().getDimensionPx(), info.getOriginalURI(), targetRect, ccitt.getColorSpace(), 1, false, gen);
    }

    public void generateForm(RenderingContext context, Image image2, PSImageFormResource form) throws IOException {
        PSRenderingContext psContext = (PSRenderingContext)context;
        PSGenerator gen = psContext.getGenerator();
        ImageRawCCITTFax ccitt = (ImageRawCCITTFax)image2;
        ImageInfo info = image2.getInfo();
        String imageDescription = info.getMimeType() + " " + info.getOriginalURI();
        ImageEncoderCCITTFax encoder2 = new ImageEncoderCCITTFax(ccitt);
        ImageFormGenerator formGen = new ImageFormGenerator(form.getName(), imageDescription, info.getSize().getDimensionPt(), info.getSize().getDimensionPx(), encoder2, ccitt.getColorSpace(), 1, false);
        formGen.generate(gen);
    }

    public int getPriority() {
        return 200;
    }

    public Class getSupportedImageClass() {
        return ImageRawCCITTFax.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    public boolean isCompatible(RenderingContext targetContext, Image image2) {
        PSRenderingContext psContext;
        if (targetContext instanceof PSRenderingContext && (psContext = (PSRenderingContext)targetContext).getGenerator().getPSLevel() >= 2) {
            return image2 == null || image2 instanceof ImageRawCCITTFax;
        }
        return false;
    }
}

