/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.extensions;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.xml.transform.TransformerException;
import org.apache.xalan.serialize.SerializerUtils;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.transformer.ClonerToResultTree;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMAxisIterator;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.serializer.SerializationHandler;
import org.apache.xml.utils.QName;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.DescendantIterator;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.OneStepIterator;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XRTreeFrag;
import org.apache.xpath.objects.XString;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXException;

public class XSLProcessorContext {
    private TransformerImpl transformer;
    private Stylesheet stylesheetTree;
    private DTM sourceTree;
    private int sourceNode;
    private QName mode;

    public XSLProcessorContext(TransformerImpl transformer, Stylesheet stylesheetTree) {
        this.transformer = transformer;
        this.stylesheetTree = stylesheetTree;
        XPathContext xctxt = transformer.getXPathContext();
        this.mode = transformer.getMode();
        this.sourceNode = xctxt.getCurrentNode();
        this.sourceTree = xctxt.getDTM(this.sourceNode);
    }

    public TransformerImpl getTransformer() {
        return this.transformer;
    }

    public Stylesheet getStylesheet() {
        return this.stylesheetTree;
    }

    public Node getSourceTree() {
        return this.sourceTree.getNode(this.sourceTree.getDocumentRoot(this.sourceNode));
    }

    public Node getContextNode() {
        return this.sourceTree.getNode(this.sourceNode);
    }

    public QName getMode() {
        return this.mode;
    }

    /*
     * WARNING - void declaration
     */
    public void outputToResultTree(Stylesheet stylesheetTree, Object obj) throws TransformerException, MalformedURLException, FileNotFoundException, IOException {
        try {
            LocPathIterator iterator2;
            XObject value2;
            SerializationHandler rtreeHandler = this.transformer.getResultTreeHandler();
            XPathContext xctxt = this.transformer.getXPathContext();
            if (obj instanceof XObject) {
                value2 = (XObject)obj;
            } else if (obj instanceof String) {
                value2 = new XString((String)obj);
            } else if (obj instanceof Boolean) {
                value2 = new XBoolean((boolean)((Boolean)obj));
            } else if (obj instanceof Double) {
                value2 = new XNumber((Double)obj);
            } else if (obj instanceof DocumentFragment) {
                int handle = xctxt.getDTMHandleFromNode((DocumentFragment)obj);
                value2 = new XRTreeFrag(handle, xctxt);
            } else if (obj instanceof DTM) {
                DTM dtm = (DTM)obj;
                iterator2 = new DescendantIterator();
                iterator2.setRoot(dtm.getDocument(), xctxt);
                value2 = new XNodeSet(iterator2);
            } else if (obj instanceof DTMAxisIterator) {
                DTMAxisIterator iter2 = (DTMAxisIterator)obj;
                iterator2 = new OneStepIterator(iter2, -1);
                value2 = new XNodeSet(iterator2);
            } else {
                value2 = obj instanceof DTMIterator ? new XNodeSet((DTMIterator)obj) : (obj instanceof NodeIterator ? new XNodeSet(new NodeSetDTM((NodeIterator)obj, xctxt)) : (obj instanceof Node ? new XNodeSet(xctxt.getDTMHandleFromNode((Node)obj), xctxt.getDTMManager()) : new XString(obj.toString())));
            }
            int type = value2.getType();
            switch (type) {
                case 1: 
                case 2: 
                case 3: {
                    String s2 = value2.str();
                    rtreeHandler.characters(s2.toCharArray(), 0, s2.length());
                    break;
                }
                case 4: {
                    int pos;
                    DTMIterator nl = value2.iter();
                    while (-1 != (pos = nl.nextNode())) {
                        void var9_12;
                        DTM dtm = nl.getDTM((int)var9_12);
                        void top = var9_12;
                        while (-1 != pos) {
                            rtreeHandler.flushPending();
                            ClonerToResultTree.cloneToResultTree((int)var9_12, dtm.getNodeType((int)var9_12), dtm, rtreeHandler, true);
                            int nextNode = dtm.getFirstChild((int)var9_12);
                            while (-1 == nextNode) {
                                if (1 == dtm.getNodeType((int)var9_12)) {
                                    rtreeHandler.endElement("", "", dtm.getNodeName((int)var9_12));
                                }
                                if (top == var9_12) break;
                                nextNode = dtm.getNextSibling((int)var9_12);
                                if (-1 != nextNode || top != (pos = dtm.getParent((int)var9_12))) continue;
                                if (1 == dtm.getNodeType(pos)) {
                                    rtreeHandler.endElement("", "", dtm.getNodeName(pos));
                                }
                                nextNode = -1;
                                break;
                            }
                            pos = nextNode;
                        }
                    }
                    break;
                }
                case 5: {
                    SerializerUtils.outputResultTreeFragment(rtreeHandler, value2, this.transformer.getXPathContext());
                }
            }
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
    }
}

