/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl.imageio;

import javax.imageio.metadata.IIOMetadata;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ImageIOUtil {
    public static final Object IMAGEIO_METADATA = IIOMetadata.class;

    private ImageIOUtil() {
    }

    public static void extractResolution(IIOMetadata iiometa, ImageSize size2) {
        Element metanode;
        Element dim;
        if (iiometa != null && iiometa.isStandardMetadataFormatSupported() && (dim = ImageIOUtil.getChild(metanode = (Element)iiometa.getAsTree("javax_imageio_1.0"), "Dimension")) != null) {
            float value2;
            double dpiHorz = size2.getDpiHorizontal();
            double dpiVert = size2.getDpiVertical();
            Element child = ImageIOUtil.getChild(dim, "HorizontalPixelSize");
            if (child != null && (value2 = Float.parseFloat(child.getAttribute("value"))) != 0.0f && !Float.isInfinite(value2)) {
                dpiHorz = 25.4f / value2;
            }
            if ((child = ImageIOUtil.getChild(dim, "VerticalPixelSize")) != null && (value2 = Float.parseFloat(child.getAttribute("value"))) != 0.0f && !Float.isInfinite(value2)) {
                dpiVert = 25.4f / value2;
            }
            size2.setResolution(dpiHorz, dpiVert);
            size2.calcSizeFromPixels();
        }
    }

    public static Element getChild(Element el, String name) {
        NodeList nodes = el.getElementsByTagName(name);
        if (nodes.getLength() > 0) {
            return (Element)nodes.item(0);
        }
        return null;
    }

    public static void dumpMetadataToSystemOut(IIOMetadata iiometa) {
        String[] metanames = iiometa.getMetadataFormatNames();
        for (int j = 0; j < metanames.length; ++j) {
            System.out.println("--->" + metanames[j]);
            ImageIOUtil.dumpNodeToSystemOut(iiometa.getAsTree(metanames[j]));
        }
    }

    private static void dumpNodeToSystemOut(Node node) {
        try {
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            DOMSource src = new DOMSource(node);
            StreamResult res = new StreamResult(System.out);
            trans.transform(src, res);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

