/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.writer.imageio;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.apache.xmlgraphics.image.writer.ImageWriter;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.apache.xmlgraphics.image.writer.MultiImageWriter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImageIOImageWriter
implements ImageWriter,
IIOWriteWarningListener {
    private static final String STANDARD_METADATA_FORMAT = "javax_imageio_1.0";
    private String targetMIME;

    public ImageIOImageWriter(String mime) {
        this.targetMIME = mime;
    }

    public void writeImage(RenderedImage image2, OutputStream out) throws IOException {
        this.writeImage(image2, out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeImage(RenderedImage image2, OutputStream out, ImageWriterParams params) throws IOException {
        javax.imageio.ImageWriter iiowriter = this.getIIOImageWriter();
        iiowriter.addIIOWriteWarningListener(this);
        ImageOutputStream imgout = ImageIO.createImageOutputStream(out);
        try {
            ImageWriteParam iwParam = this.getDefaultWriteParam(iiowriter, image2, params);
            ImageTypeSpecifier type = iwParam.getDestinationType() != null ? iwParam.getDestinationType() : ImageTypeSpecifier.createFromRenderedImage(image2);
            IIOMetadata meta = iiowriter.getDefaultImageMetadata(type, iwParam);
            if (params != null && meta != null) {
                meta = this.updateMetadata(meta, params);
            }
            iiowriter.setOutput(imgout);
            IIOImage iioimg = new IIOImage(image2, null, meta);
            iiowriter.write(null, iioimg, iwParam);
        }
        finally {
            imgout.close();
            iiowriter.dispose();
        }
    }

    private javax.imageio.ImageWriter getIIOImageWriter() {
        Iterator<javax.imageio.ImageWriter> iter2 = ImageIO.getImageWritersByMIMEType(this.getMIMEType());
        javax.imageio.ImageWriter iiowriter = null;
        if (iter2.hasNext()) {
            iiowriter = iter2.next();
        }
        if (iiowriter == null) {
            throw new UnsupportedOperationException("No ImageIO codec for writing " + this.getMIMEType() + " is available!");
        }
        return iiowriter;
    }

    protected ImageWriteParam getDefaultWriteParam(javax.imageio.ImageWriter iiowriter, RenderedImage image2, ImageWriterParams params) {
        ImageWriteParam param2 = iiowriter.getDefaultWriteParam();
        if (params != null && params.getCompressionMethod() != null) {
            param2.setCompressionMode(2);
            param2.setCompressionType(params.getCompressionMethod());
        }
        return param2;
    }

    protected IIOMetadata updateMetadata(IIOMetadata meta, ImageWriterParams params) {
        if (meta.isStandardMetadataFormatSupported()) {
            IIOMetadataNode root2 = (IIOMetadataNode)meta.getAsTree(STANDARD_METADATA_FORMAT);
            IIOMetadataNode dim = ImageIOImageWriter.getChildNode(root2, "Dimension");
            if (params.getResolution() != null) {
                IIOMetadataNode child = ImageIOImageWriter.getChildNode(dim, "HorizontalPixelSize");
                if (child == null) {
                    child = new IIOMetadataNode("HorizontalPixelSize");
                    dim.appendChild(child);
                }
                child.setAttribute("value", Double.toString(params.getResolution().doubleValue() / 25.4));
                child = ImageIOImageWriter.getChildNode(dim, "VerticalPixelSize");
                if (child == null) {
                    child = new IIOMetadataNode("VerticalPixelSize");
                    dim.appendChild(child);
                }
                child.setAttribute("value", Double.toString(params.getResolution().doubleValue() / 25.4));
            }
            try {
                meta.mergeTree(STANDARD_METADATA_FORMAT, root2);
            }
            catch (IIOInvalidTreeException e) {
                throw new RuntimeException("Cannot update image metadata: " + e.getMessage());
            }
        }
        return meta;
    }

    protected static IIOMetadataNode getChildNode(Node n, String name) {
        NodeList nodes = n.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            if (!name.equals(child.getNodeName())) continue;
            return (IIOMetadataNode)child;
        }
        return null;
    }

    public String getMIMEType() {
        return this.targetMIME;
    }

    public boolean isFunctional() {
        Iterator<javax.imageio.ImageWriter> iter2 = ImageIO.getImageWritersByMIMEType(this.getMIMEType());
        return iter2.hasNext();
    }

    public void warningOccurred(javax.imageio.ImageWriter source, int imageIndex, String warning) {
        System.err.println("Problem while writing image using ImageI/O: " + warning);
    }

    public MultiImageWriter createMultiImageWriter(OutputStream out) throws IOException {
        return new IIOMultiImageWriter(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsMultiImageWriter() {
        javax.imageio.ImageWriter iiowriter = this.getIIOImageWriter();
        try {
            boolean bl = iiowriter.canWriteSequence();
            return bl;
        }
        finally {
            iiowriter.dispose();
        }
    }

    private class IIOMultiImageWriter
    implements MultiImageWriter {
        private javax.imageio.ImageWriter iiowriter;
        private ImageOutputStream imageStream;

        public IIOMultiImageWriter(OutputStream out) throws IOException {
            this.iiowriter = ImageIOImageWriter.this.getIIOImageWriter();
            if (!this.iiowriter.canWriteSequence()) {
                throw new UnsupportedOperationException("This ImageWriter does not support writing multiple images to a single image file.");
            }
            this.iiowriter.addIIOWriteWarningListener(ImageIOImageWriter.this);
            this.imageStream = ImageIO.createImageOutputStream(out);
            this.iiowriter.setOutput(this.imageStream);
            this.iiowriter.prepareWriteSequence(null);
        }

        public void writeImage(RenderedImage image2, ImageWriterParams params) throws IOException {
            if (this.iiowriter == null) {
                throw new IllegalStateException("MultiImageWriter already closed!");
            }
            ImageWriteParam iwParam = ImageIOImageWriter.this.getDefaultWriteParam(this.iiowriter, image2, params);
            ImageTypeSpecifier type = iwParam.getDestinationType() != null ? iwParam.getDestinationType() : ImageTypeSpecifier.createFromRenderedImage(image2);
            IIOMetadata meta = this.iiowriter.getDefaultImageMetadata(type, iwParam);
            if (params != null && meta != null) {
                meta = ImageIOImageWriter.this.updateMetadata(meta, params);
            }
            IIOImage iioimg = new IIOImage(image2, null, meta);
            this.iiowriter.writeToSequence(iioimg, iwParam);
        }

        public void close() throws IOException {
            this.imageStream.close();
            this.imageStream = null;
            this.iiowriter.dispose();
            this.iiowriter = null;
        }
    }
}

