/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.parser;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import org.gedcom4j.io.GedcomFileReader;
import org.gedcom4j.model.StringTree;
import org.gedcom4j.parser.LinePieces;

public final class GedcomParserHelper {
    static StringTree findLast(StringTree tree, int level) {
        if (tree.level == level) {
            return tree;
        }
        StringTree lastChild = tree.children.get(tree.children.size() - 1);
        if (lastChild.level == level) {
            return lastChild;
        }
        return GedcomParserHelper.findLast(lastChild, level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static StringTree makeStringTreeFromStream(BufferedInputStream bytes) throws IOException {
        List<String> lines2 = new GedcomFileReader().getLines(bytes);
        StringTree result2 = new StringTree();
        result2.level = -1;
        try {
            int lineNum = 1;
            while (lineNum <= lines2.size()) {
                String line = lines2.get(lineNum - 1);
                LinePieces lp = new LinePieces(line);
                StringTree st = new StringTree();
                st.lineNum = lineNum++;
                st.level = lp.level;
                st.id = lp.id;
                st.tag = lp.tag;
                st.value = lp.remainder;
                StringTree addTo = GedcomParserHelper.findLast(result2, lp.level - 1);
                addTo.children.add(st);
                st.parent = addTo;
            }
        }
        finally {
            if (bytes != null) {
                bytes.close();
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static StringTree readFile(String filename) throws IOException {
        FileInputStream fis = new FileInputStream(filename);
        try {
            StringTree stringTree = GedcomParserHelper.makeStringTreeFromStream(new BufferedInputStream(fis));
            return stringTree;
        }
        finally {
            fis.close();
        }
    }

    static StringTree readStream(BufferedInputStream stream) throws IOException {
        return GedcomParserHelper.makeStringTreeFromStream(stream);
    }

    static boolean referencesAnotherNode(StringTree st) {
        return st.value != null && st.value.matches("\\@.*\\@");
    }

    private GedcomParserHelper() {
    }
}

